Multiplayer-mode allows multiple operators (players) to connect to the same Sliver server and collaborate on engagements. The easiest way to set up a server for multiplayer is to use the [Linux install script](/docs?name=Linux+Install+Script) which will configure the server as a systemd service. However, any Sliver server binary supports multiplayer mode.

```
                    ┌──────────────────┐  C2
                    │                  │  Protocol    ┌─────────┐
                    │ Sliver C2 Server ├─────────────►│ Implant │
                    │                  │              └─────────┘
                    └──────────────────┘
                            ▲
                            │
         gRPC/mTLS          │
      ┌────────────┬────────┴─────┬───────────┐
      │            │              │           │
┌─────┴──┐         │              │        ┌──┴─────┐
│Windows │    ┌────┴───┐     ┌────┴───┐    │Windows │
│Operator│    │Linux   │     │MacOS   │    │Operator│
└────────┘    │Operator│     │Operator│    └────────┘
              └────────┘     └────────┘
```

## New Operators

Operators will need to download their preferred platform's client software from the releases page. Clients can connect to servers of differing platforms (e.g. a Windows client can connect to a Linux server). Operators and servers authenticate using Mutual TLS, however all the certificates are managed automatically for you.

- If you did not install the server as a systemd service, be sure to leave the server console running in screen or [tmux](https://github.com/tmux/tmux) after starting the multiplayer listener.
- If you did install the server as systemd service see the CLI section below for an alternative to the console commands for generating operator configs.

Operators need a configuration file generated by the Sliver server to connect in multiplayer mode. The Sliver client can support multiple configuration files, but you can only be connected to one server at a time (per process).

From the server use the `new-operator` command to generate a new operator configuration file. You'll need to specify the operator's `--name` and the `--lhost` of the server (e.g., its public IP). Then from the server start a multiplayer listener using the `multiplayer` command to allow operators to connect:

**Note:** The `new-operator` and `multiplayer` commands are only accessible from the server's console

```
[server] sliver > new-operator --name moloch --lhost 1.2.3.4

[*] Generating new client certificate, please wait ...
[*] Saved new client config to: /Users/moloch/Desktop/moloch_example.com.cfg

[server] sliver > multiplayer

[*] Multiplayer mode enabled!

```

**IMPORTANT:** Before clients can connect to a server you must start an RPC listener with the `multiplayer` command. The default port is TCP/31337.

You can now give this configuration file `moloch_example.com.cfg` to the operator and they can connect to the server using the `sliver-client` binary. The Sliver client will look for configuration files in `~/.sliver-client/configs/` or you can import configs using the `import` CLI. The configs directory can contain multiple configs for different servers.

```
$ ./sliver-client import ./moloch_example.com.cfg

$ ./sliver-client
? Select a server:  [Use arrows to move, type to filter]
> example.com
  localhost
```

### Server CLI / Daemon Mode Multiplayer

If the server is running in daemon mode (as is the default with the Linux install script), that means the multiplayer listener is started for you without an interactive console. You can use the server binaries' CLI to generate operator configuration files to connect:

```
./sliver-server operator --name zer0cool --lhost 1.2.3.4 --save zer0cool.cfg
```

The installation scripts by default will place the `sliver-server` binary in `/root`.

### Tailscale Integration

Sliver v1.6 supports multiplayer integration with [Tailscale](https://tailscale.com/), which is an excellent option when wanting to maintain operational security.

```
$ export TS_AUTHKEY=<tailscale authkey>
$ ./sliver-server

sliver > multiplayer -T
```

You should now see a new Tailscale host named `sliver-server-<machine>`, you can set this using the `--lhost` flag. Use this as the hostname when connecting to the Sliver server from any other host on the Tailscale network.
